<?php
/*
# ------------------------------------------------------------------------
# JA Tabs Plugins for Joomla 1.5
# ------------------------------------------------------------------------
# Copyright (C) 2004-2010 JoomlArt.com. All Rights Reserved.
# @license GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
# Author: JoomlArt.com
# Websites: http://www.joomlart.com - http://www.joomlancers.com.
# ------------------------------------------------------------------------
*/

// Check to ensure this file is included in Joomla!

defined( '_JEXEC' ) or die();
jimport( 'joomla.plugin.plugin' );
jimport('joomla.application.module.helper');

//Check com k2 was installed
if(file_exists(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php'))
{
	require_once(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'route.php');
}
if(file_exists(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php'))
{
	require_once(JPATH_SITE.DS.'components'.DS.'com_k2'.DS.'helpers'.DS.'utilities.php');
}
//end check

/**
 * Jatabs Content Plugin
 *
 * @package		Joomla
 * @subpackage	Content
 * @since 		1.5
 */


class plgContentJA_tabs extends JPlugin
{
  	var $style_default = '';
  
	function plgContentJA_tabs( &$subject, $params=null )
	{
		if (!$subject) return;
		parent::__construct( $subject, $params );
		$this->loadLanguage ( null);
	}

	/**
	 * tabs prepare content method
	 *
	 * Method is called by the view
	 *
	 * @param 	object		The article object.  Note $article->text is also available
	 * @param 	object		The article params
	 * @param 	int			The 'page' number
	 */
	function onPrepareContent( &$article, &$params, $limitstart )
	{
		global $mainframe;
		
		$plugin	= JPluginHelper::getPlugin('content', 'ja_tabs');
		$pluginParams	= new JParameter( $plugin->params );

		if (JString::strpos( $article->text, '{jatabs' ) === false){
			$HSmethodDIRECT = false;
		}else{
			$HSmethodDIRECT = true;
		}
		
		if(!defined("JAMOOTAB_PLUGIN_HEADTAG")) $this->Jatabs_PrepareSettings($pluginParams);
		
		/*@var globol style */	  		
		if (!$this->style_default) {  
	      $this->style_default = $pluginParams->get('style') ? $pluginParams->get('style'):'default';
		}
				
		if($HSmethodDIRECT){
			require_once('plugins/content/ja_tabs/parser.php');
			$parser = new ReplaceCallbackParser('jatabs');
			$article->text =  $parser->parse ($article->text, array(&$this, 'Jatabs_replacer_DIRECT'));			
		}
		return $article->text;
	}

	function Jatabs_PrepareSettings($pluginParams){
		global $mainframe;
		JHtml::_('behavior.mootools');
		$hs_base    = 'plugins/content/ja_tabs/';
		
		$app = JFactory::getApplication();
		JHTML::script ('ja.tabs.js', $hs_base);
		
		JHTML::stylesheet ('ja.tabs.css', $hs_base);
		define("JAMOOTAB_PLUGIN_HEADTAG", TRUE);
	}
	
	function Jatabs_replacer_DIRECT($plgAttr, $plgContent)
	{		
		//params of tab
		
		$params = '';
		
		$params = $this->parseParams($plgAttr);		
		
		if (isset($params['ajax']) && $params['ajax']) {
			$params['useAjax'] = "true";
		}
		else{
			//set params for ajax
			$params['useAjax'] = "false";		
		}

		switch ($params['type']){
			case 'content':
				return $this->parseTabContent($plgContent, $params);				
			case 'modules':				
				return $this->parseTabModules($params);
			case 'module':
				return $this->parseTabModule($params);
			case 'articles':	
				return $this->parseTabArticle($params);
			case 'k2items':
				return $this->parseTabK2Items($params);
		}		
	}	
	
	function parseTabK2Items($params)
	{
		$list = null; $lis = ''; $divs = '';
		
		if(isset($params['ids'])){
			$list = $this->getListK2($params['ids'], '');
		}
		elseif (isset($params['catid'])){
			if(!isset($params['numberTabs']) || $params['numberTabs']<=0 || !is_numeric($params['numberTabs']) ) 	$params['numberTabs']  	= 0;
			$list = $this->getListK2('', $params['catid'], $params['numberTabs']);
		}		

		$ids  = array();
		if($list){
			foreach ($list as $row){
				$ids[] = $row->id;
				$title = $row->title;
				if(JText::_($row->alias)!=$row->alias) $title = JText::_($row->alias);
				$lis  .= "<li title=\"".strip_tags($row->title)."\"><h3><span>".$title."</span></h3></li>";
				$divs .= "<div  class=\"ja-tab-content\">
							<div class=\"ja-tab-subcontent\">";
				
				if($params['useAjax']=='false'){
					if(!isset($params['view']) || $params['view']!='fulltext' || $row->fulltext ==''){
						$divs .= $row->introtext;
					}
					else{
						$divs .= $row->introtext.$row->fulltext;								
					}
				}													
				$divs .= 	'  </div>
						 </div>';											
			}
			
			if($params['useAjax']=='true'){
				$params['ajaxUrl'] =JURI::base().'plugins/content/ja_tabs/ajaxloader.php?type=content&view='.$params['view'];
			}
			
			$params['ids'] = implode(',', $ids);
			
			return $this->writeTabs($lis, $divs, $params);
		}
		
		return '';
	}
    function getListK2($ids='', $catid='', $limit=0)
	{
		global $mainframe;
		
		 	$db	    = &JFactory::getDBO();
			
			$my = &JFactory::getUser();

			$aid	= $my->get( 'aid', 0 );
			$date =& JFactory::getDate();
			$now  = $date->toMySQL();
			
			$query = "SELECT a.*,u.name as creater, cc.name AS categoryname,cc.id AS categoryid, cc.alias AS categoryalias, cc.params AS categoryparams";
			$query .= " FROM #__k2_items as a LEFT JOIN #__k2_categories cc ON cc.id = a.catid";
			$query .= " left JOIN #__users AS u ON a.created_by = u.id";
			$query .= " WHERE a.published = 1 AND a.access <= {$aid} AND a.trash = 0 AND cc.published = 1 AND cc.access <= {$aid} AND cc.trash = 0";
			$query .= " AND ( a.publish_up = ".$db->Quote( $db->getNullDate() )." OR a.publish_up <= ".$db->Quote($now)." )";
			$query .= " AND ( a.publish_down = ".$db->Quote( $db->getNullDate() )." OR a.publish_down >= ".$db->Quote($now)." )";
			
			if($ids!=''){
				$query .= " AND a.id IN($ids)";
			}
			if($catid != '') {
				if(strpos($catid,","))
				{
					$query .= " AND cc.id IN ( $catid )";
				}
				else
				{
					$query .= " AND cc.id = $catid";
				}
			}
			$query .= ' ORDER BY a.ordering ' ;
			
			if($catid != '' && $limit>0) {
				$query .=	"LIMIT 0, $limit";
		    }
		
			$db->setQuery($query);
			
			$rows = $db->loadObjectlist();
			if(!empty($rows))
			{
				foreach($rows as $row)
				{
					$rows [$i]->link = urldecode(JRoute::_(K2HelperRoute::getItemRoute($row->id.':'.urlencode($row->alias), $row->catid.':'.urlencode($row->categoryalias))));
					$i ++;
				}
			}
			return $rows;
	}
	function parseTabContent($matches, $params){		
		$tabs ='';
		$_SESSION['li'] = null;
		$_SESSION['div'] = null;
		$regex = $this->getSubPattern('tab');
		preg_replace_callback($regex, array(&$this, 'wirentTabContent'), $matches);
		if($_SESSION['li']!=null){
			return $this->writeTabs($_SESSION['li'], $_SESSION['div'], $params);
		}
		return '';
	}
	
	function wirentTabContent(&$matches){
		$params = $this->parseParams($matches[1]);
		//Add color option for each tab
		$color = (isset($params['color']))?" class=\"{$params['color']}\"":"";
		$_SESSION['li'] .= "<li><h3$color><span>".JText::_($params['title'])."</span></h3></li>";
		
		$_SESSION['div'] .= "<div class=\"ja-tab-content\">
								<div class=\"ja-tab-subcontent\">"
									.$matches[2]
							.'  </div>
							</div>';		
	}
	
	function parseTabModules($params){
		$module_content = ''; $lis = ''; $divs = '';
		$list =  JModuleHelper::getModules(trim($params['module']));
		
		$ids = array();
		for($j=0; $j<count($list); $j++){
			if($list[$j]->module!='mod_jatabs'){
				$mparams = new JParameter ($list[$j]->params);
				$clssfx = $mparams->get ('moduleclass_sfx', '');
				$lis  .= "<li title=\"".strip_tags($list[$j]->title)."\"".($clssfx?" class=\"ja-tab-title$clssfx\"":"")."><h3><span>".JText::_($list[$j]->title)."</span></h3></li>";
				$divs .= "<div  class=\"ja-tab-content".($clssfx?" ja-tab-content$clssfx":"")."\">
							<div class=\"ja-tab-subcontent\">";
				if($params['useAjax']=='false'){
					$divs	.=	JModuleHelper::renderModule($list[$j]);									
				}			
				$divs .= 	'  </div>
						 </div>';
				
				$ids[] = $list[$j]->id;
			}			
		}				
		
		if($params['useAjax']=='true') {
			$params['ajaxUrl'] = JURI::base().'plugins/content/ja_tabs/ajaxloader.php?type=modules';
		}
			
		if($lis!=''){
			
			$params['ids'] = implode(',', $ids);
			
			return $this->writeTabs($lis, $divs, $params);
		}		
		
		return ;	
	}
	
	function parseTabModule($params){
		$lis = ''; $divs = ''; $list_module=array();
		if(isset($params['modulename']) && $params['modulename']) $list_module = explode(",", $params['modulename']);

		$ids = array();
		
		for($i=0; $i<count($list_module); $i++){
			if ($list_module[$i]!='mod_jatabs') {
				$module =  JModuleHelper::getModule(substr(trim($list_module[$i]), 4 ));
				
				if($module && $module->id){
					$mparams = new JParameter ($module->params);
					$clssfx = $mparams->get ('moduleclass_sfx', '');
					$lis  .= "<li title=\"".strip_tags($module->title)."\"".($clssfx?" class=\"ja-tab-title$clssfx\"":"")."><h3><span>".JText::_($module->title)."</span></h3></li>";
					$divs .= "<div  class=\"ja-tab-content".($clssfx?" ja-tab-content$clssfx":"")."\">
								<div class=\"ja-tab-subcontent\">";
					if($params['useAjax']=='false'){
						$divs	.=	JModuleHelper::renderModule($module);									
					}		
						
					$divs .= 	'  </div>
							 </div>';		
					$ids[] = $module->id;		
				}			
			}
				
		}		
		if($lis!=''){
			
			$params['ids'] = implode(',', $ids);
			
			if($params['useAjax']=='true'){
				$params['ajaxUrl'] = JURI::base().'plugins/content/ja_tabs/ajaxloader.php?type=modules';
			}
			
			return $this->writeTabs($lis, $divs, $params);
		}
		return '';		
	}		
	
	function parseTabArticle($params){
		$list = null; $lis = ''; $divs = '';
		if(isset($params['ids'])){
			$list = $this->getList($params['ids'], '');
		}
		elseif (isset($params['catid'])){
			if(!isset($params['numberTabs']) || $params['numberTabs']<=0 || !is_numeric($params['numberTabs']) ) 	$params['numberTabs']  	= 0;
			$list = $this->getList('', $params['catid'], $params['numberTabs']);
		}				

		$ids  = array();
		if($list){
			foreach ($list as $row){
				$ids[] = $row->id;
				$title = $row->title;
				if(JText::_($row->alias)!=$row->alias) $title = JText::_($row->alias);
				$lis  .= "<li title=\"".strip_tags($row->title)."\"><h3><span>".$title."</span></h3></li>";
				$divs .= "<div  class=\"ja-tab-content\">
							<div class=\"ja-tab-subcontent\">";
				
				if($params['useAjax']=='false'){
					if(!isset($params['view']) || $params['view']!='fulltext' || $row->fulltext ==''){
						$divs .= $row->introtext;
					}
					else{
						$divs .= $row->introtext.$row->fulltext;								
					}
				}													
				$divs .= 	'  </div>
						 </div>';											
			}
			
			if($params['useAjax']=='true'){
				$params['ajaxUrl'] =JURI::base().'plugins/content/ja_tabs/ajaxloader.php?type=content&view='.$params['view'];
			}
			
			$params['ids'] = implode(',', $ids);
			
			return $this->writeTabs($lis, $divs, $params);
		}
		
		return '';
	}
		
	function writeTabs($lis, $divs, $params){
		global $mainframe;
		$padding = '';
		
		if(!isset($params['width']) || $params['width']<0 || (!is_numeric($params['width']) && $params['width']!='100%')) 	$params['width']  	= '100%';
		
		if(!isset($params['height']) || $params['height']<0 || (!is_numeric($params['height']) && $params['height']!='auto')) 	$params['height'] 	= 'auto';	
		
		if(!isset($params['heightTabs']) || $params['heightTabs']<0  || (!is_numeric($params['heightTabs']) && $params['heightTabs']!='auto')) {
			$params['heightTabs'] 	= 30;	
		}
				
		if (!isset($params['skipAnim']) || !in_array($params['skipAnim'], array('false', 'true'))) {
			$params['skipAnim'] = 'false';
		}	
		$params['skipAnim'] = strtolower($params['skipAnim']);
				
		if(!isset($params['animType'])) 	$params['animType'] = 'animMoveHor';
		
		
		if(!isset($params['position']) || !in_array(strtolower($params['position']), array('top', 'bottom', 'left', 'right'))){
			$params['position'] = 'top';
		}
		$params['position'] = strtolower($params['position'] );

		if(!isset($params['widthTabs']) && ($params['position']=='left' || $params['position']=='right')){
			$params['widthTabs'] 		= 150;			
		}
		
		if ($params['position']=='top' || $params['position']=='bottom'){
			$params['widthTabs']  = $params['width'];
			$width = $params['width'];
		}		
		
		if ($params['position']=='left' && is_numeric($params['widthTabs'] )) {
			$width = $params['width']-$params['widthTabs'];
		}
		
		if ($params['position']=='right' && is_numeric($params['widthTabs'] )) {			
			$padding = 'left:'.($params['widthTabs'] + 5).'px;';
			$width = $params['width']-$params['widthTabs'];			
		}
		
		if (!isset($params['style']) || $params['style']=='') {
			$params['style'] = $this->style_default;
		}	
		
		
		if (!isset($params['mouseType']) || !in_array(strtolower($params['mouseType']), array('click', 'mouseover'))) {
			$params['mouseType'] = 'click';
		}
		$params['mouseType'] = strtolower($params['mouseType']);		
		//tab active
		if (!isset($params['activateOnLoad']) && JRequest::getVar ('tab','')) {
			$params['activateOnLoad'] = JRequest::getVar ('tab','');
		}
		
		$override = ''; $k='';
		
		foreach($params as $k=>$value){
			if($k!='type' && $k!='module' && $k!='modulename' && $k!='widthTabs' && $k!='heightTabs' && $k!='view' && $k!='ajax')
			{
				if(is_numeric($value) || $k=='skipAnim' || $k=='useAjax'){
					$override .= $k.":".$value.",";
				}				
				else	$override .= $k.":'".$value."',";
			}
		}		
			
		if($override!=''){
			$override = substr($override, 0, strlen($override)-1);
		}

		if(!defined("JAMOOTAB_HEADTAG_".strtoupper($params['style']))){
			JHTML::stylesheet ('style.css', 'plugins/content/ja_tabs/themes/'.$params['style'].'/');
			define("JAMOOTAB_HEADTAG_".strtoupper($params['style']), true);
		}
		
		$id = 'myTab-'.rand(); $idtab = rand();
		
		$html = ''; $style = 'style="';
			if (is_numeric($params['height']) && $params['height']>0) {
				$style .= 'height:'.$params['height'].'px;';
			}
			if (is_numeric($params['width']) && $params['width']>0) {
				$style .= 'width:'.$params['width'].'px;';
			}
			else{
				$style .= 'width:100%;';
			}
			$style .= '"';
			
			$html .= '<div class="ja-tabswrap '.strtolower($params['style']).'" '.$style.'>';
			
			$html.=	 '	<div  id="'.$id.'" class="container" >';	
			
			if($params['position']=='top'){	
				/* set style for title top */
				$styleTop = 'style="';				
				if (is_numeric($params['heightTabs']) && $params['heightTabs']>0) {
					$styleTop .= 'height:'.$params['heightTabs'].'px;';
				}				
				$styleTop .= '"';		
									
				$html .= '	<div class="ja-tabs-title-'.$params['position'].'" '.$styleTop.'>';
			}
			elseif($params['position']!='bottom'){
				/* set style for title top */
				$styleMiddle = 'style="';
								
				if (is_numeric($params['widthTabs']) && $params['widthTabs']>0) {
					$styleMiddle .= 'width:'.$params['widthTabs'].'px;';
				}
				else{
					$styleMiddle .= 'width:'.$params['widthTabs'].';';
				}
				$styleMiddle .= '"';	
				
				$html.=	 '	<div class="ja-tabs-title-'.$params['position'].'" '.$styleMiddle.'>';
			}			

			$style = '';
			if (is_numeric($params['height']) && $params['height']>0) {
				$style = 'style="height:0px;"';
			}		

			if ($params['position']=='bottom') {
					$html.=	 '<div class="ja-tab-panels-'.$params['position'].'" '.$style.'>'
							.	$divs
							.'</div>
							<div class="ja-tabs-title-'.$params['position'].'" >			
								<ul class="ja-tabs-title">'
									.$lis
							.	'</ul>
							 </div>						
							';	
			}	
			else{	
					$html.=	 '			
								<ul class="ja-tabs-title">'
									.$lis
							.	'</ul>
							</div>						
							<div class="ja-tab-panels-'.$params['position'].'" '.$style.'>'
							.	$divs
							.'</div>';
			}
									
			$html.=	 '	</div>
					</div>';
			$html .= '<script type="text/javascript" charset="utf-8">
						window.addEvent("load", init);
						function init() {
							myTabs1 = new JATabs("'.$id.'", {'.$override.'});							
						}
						//new JATabs("'.$id.'", {'.$override.'});													
				     </script>';			
		return $html;
	}
	
	function getList($ids='', $catid='', $limit=0)
	{
		global $mainframe;
		$db 	= JFactory::getDBO();
		$user 	= JFactory::getUser();
		$aid	= $user->get('aid', 0);

		$contentConfig	= JComponentHelper::getParams( 'com_content' );
		$noauth			= !$contentConfig->get('shownoauth');

		jimport('joomla.utilities.date');
		$date = new JDate();
		$now = $date->toMySQL();

		$nullDate = $db->getNullDate();

		// query to determine article count
		$query = 'SELECT a.*' .			
			' FROM #__content AS a' .
			' INNER JOIN #__categories AS cc ON cc.id = a.catid' .
			' INNER JOIN #__sections AS s ON s.id = a.sectionid';
		$query .=	' WHERE a.state = 1 ' .
			($noauth ? ' AND a.access <= ' .(int) $aid. ' AND cc.access <= ' .(int) $aid. ' AND s.access <= ' .(int) $aid : '').
			' AND (a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' ) ' .
			' AND (a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )' .				
			' AND cc.section = s.id' .
			' AND cc.published = 1' .
			' AND s.published = 1';
		if($ids!=''){
			$query .= "\n AND a.id in ($ids)";
		}
		if($catid != '') {
			$query .=	" AND a.catid=$catid";
		}						
		$query .= ' ORDER BY a.ordering ' ;		
		if($catid != '' && $limit>0) {
			$query .=	"LIMIT 0, $limit";
		}

		$db->setQuery($query);
		$rows = $db->loadObjectList();		
		  
		jimport('joomla.plugin.helper');
		JPluginHelper::importPlugin('content');
		
		$app = JFactory::getApplication();
		$pparams = new JParameter('');
		
		$limitstart	= JRequest::getVar('limitstart', 0, '', 'int');
  
  		for($i=0;$i<count($rows);$i++) {
  		  $rows[$i]->text = $rows[$i]->introtext;
  		  $app->triggerEvent('onPrepareContent', array (& $rows[$i], & $params, $limitstart));
   		  $rows[$i]->introtext = $rows[$i]->text;
      	}
      	
		return $rows;
	}
	
	function getPattern ($tag) {
	 $regex = '#{'.$tag.' ([^}]*)}([^{]*){/'.$tag.'}#m';

	  return $regex;
	}

	function getSubPattern ($tag) {
	  $regex = '#\['.$tag.' ([^\]]*)\]([^\[]*)\[/'.$tag.'\]#m';
	  return $regex;
	}
	
	function parseParams($params) {
		$params = html_entity_decode($params, ENT_QUOTES);
		$regex = "/\s*([^=\s]+)\s*=\s*('([^']*)'|\"([^\"]*)\"|([^\s]*))/";
		preg_match_all($regex, $params, $matches);
		
		 $paramarray = null;
		 if(count($matches)){
			$paramarray = array();
				for ($i=0;$i<count($matches[1]);$i++){ 
				  $key = $matches[1][$i];
				  $val = $matches[3][$i]?$matches[3][$i]:($matches[4][$i]?$matches[4][$i]:$matches[5][$i]);
				  $paramarray[$key] = $val;
				}
		  }
		  return $paramarray;
	}
}
?>